/*
 * Decompiled with CFR 0.152.
 */
package dev.lone.itemsadder.Core.OtherPlugins.Citizens;

import com.google.common.collect.Iterables;
import dev.lone.itemsadder.Core.OtherPlugins.Citizens.CustomEntityTrait;
import itemsadder.m.ape;
import itemsadder.m.br;
import itemsadder.m.wa;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.SimpleNPCDataStore;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitInfo;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Storage;
import org.apache.commons.lang.reflect.MethodUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

public class CitizensHook {
    private static TraitInfo trait;
    private static boolean isReload;

    public static boolean isRegistered() {
        return trait != null;
    }

    public static void register() {
        trait = TraitInfo.create(CustomEntityTrait.class).withName("customentity");
        CitizensAPI.getTraitFactory().registerTrait(trait);
        ape.log("Registered Citizens NPC Trait: " + trait.getTraitName());
    }

    public static void unregister() {
        if (trait != null) {
            try {
                CitizensAPI.getTraitFactory().deregisterTrait(trait);
                trait = null;
                block2: for (NPC nPC : CitizensAPI.getNPCRegistry()) {
                    for (Trait trait : nPC.getTraits()) {
                        if (!trait.getName().equals("customentity")) continue;
                        nPC.data().set("has_customentity", (Object)true);
                        nPC.despawn(DespawnReason.RELOAD);
                        ape.log("Despawned Citizens NPC " + nPC.getId() + " on ItemsAdder unload.");
                        continue block2;
                    }
                }
            }
            catch (Throwable throwable) {
                ape.error("Failed to unregister CustomEntity trait for Citizens . Try to update to the latest version.", throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reload() {
        if (Iterables.size((Iterable)CitizensAPI.getNPCRegistry()) == 0) {
            return;
        }
        boolean bl2 = false;
        int n2 = 0;
        if (isReload) {
            CitizensHook.saveAll();
        }
        try {
            Citizens citizens = (Citizens)CitizensAPI.getPlugin();
            SimpleNPCDataStore simpleNPCDataStore = (SimpleNPCDataStore)wa.a(Citizens.class, "saves", (Object)citizens);
            Storage storage = (Storage)wa.a(SimpleNPCDataStore.class, "root", (Object)simpleNPCDataStore);
            Iterable iterable = storage.getKey("npc").getIntegerSubKeys();
            for (NPC nPC : CitizensAPI.getNPCRegistry()) {
                boolean bl3 = false;
                for (Trait trait : nPC.getTraits()) {
                    if (!trait.getName().equals("customentity")) continue;
                    CitizensHook.respawn(nPC);
                    ++n2;
                    if (bl2) break;
                    ape.log("Reloading ItemsAdder Custom Entities Citizens NPCs...");
                    bl2 = true;
                    break;
                }
                if (bl3 || !nPC.data().has("has_customentity")) continue;
                nPC.data().remove("has_customentity");
                nPC.despawn(DespawnReason.RELOAD);
                try {
                    for (Trait trait : iterable) {
                        int n3 = Integer.parseInt(trait.name());
                        if (n3 != nPC.getId()) continue;
                        if (!trait.keyExists("name")) {
                            throw new RuntimeException("Cound not find a name for NPC: " + nPC.getId());
                        }
                        String string = trait.getString("traitnames");
                        if (!string.contains("customentity")) continue;
                        nPC.load((DataKey)trait);
                    }
                    ++n2;
                    if (!bl2) {
                        ape.log("Reloading ItemsAdder Custom Entities Citizens NPCs...");
                        bl2 = true;
                    }
                    ape.log("Spawned Citizens NPC " + nPC.getId() + " after ItemsAdder resources load.");
                }
                catch (Throwable throwable) {
                    ape.error("Failed to respawn Custom Entities Citizens NPC: " + String.valueOf(nPC), throwable);
                }
            }
        }
        catch (Throwable throwable) {
            ape.error("Failed to respawn Custom Entities Citizens NPCs", throwable);
        }
        finally {
            if (n2 > 0) {
                ape.log("Reloaded " + n2 + " ItemsAdder Custom Entities Citizens NPCs.");
            }
        }
        isReload = true;
    }

    public static void saveAll() {
        CitizensHook.saveAll(false);
    }

    public static void saveAll(boolean bl2) {
        try {
            ape.fO("Saving Citizens NPCs");
            try {
                ((Citizens)CitizensAPI.getPlugin()).storeNPCs(bl2);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                Method method = MethodUtils.getAccessibleMethod(Citizens.class, (String)"storeNPCs", Boolean.TYPE);
                method.invoke((Object)CitizensAPI.getPlugin(), false);
            }
        }
        catch (Throwable throwable) {
            ape.error("Failed to save Citizens NPCs. Try to update to the latest version.", throwable);
        }
    }

    public static boolean isNPC(@Nullable LivingEntity livingEntity) {
        if (livingEntity == null) {
            return false;
        }
        return CitizensAPI.getNPCRegistry().isNPC((Entity)livingEntity);
    }

    public static void spawn(NPC nPC) {
        if (!nPC.isSpawned()) {
            nPC.spawn(nPC.getStoredLocation());
        }
    }

    public static void respawn(NPC nPC) {
        if (nPC.isSpawned()) {
            nPC.despawn();
            nPC.spawn(nPC.getStoredLocation());
        }
    }

    public static boolean isNameplateVisible(NPC nPC) {
        return (Boolean)nPC.data().get(NPC.Metadata.NAMEPLATE_VISIBLE, (Object)true);
    }

    @Nullable
    public static NPC getSelected(CommandSender commandSender) {
        return CitizensAPI.getDefaultNPCSelector().getSelected(commandSender);
    }

    @Nullable
    public static br getSelectedNpcEntityRenderer(CommandSender commandSender) {
        NPC nPC = CitizensAPI.getDefaultNPCSelector().getSelected(commandSender);
        if (nPC == null) {
            return null;
        }
        CustomEntityTrait customEntityTrait = (CustomEntityTrait)nPC.getTraitNullable(CustomEntityTrait.class);
        if (customEntityTrait == null) {
            return null;
        }
        return customEntityTrait.getRenderer();
    }

    public static List getNpcsIds() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (NPC nPC : CitizensAPI.getNPCRegistry()) {
            arrayList.add(Integer.toString(nPC.getId()));
        }
        return arrayList;
    }

    static {
        isReload = false;
    }
}

