/*
 * Decompiled with CFR 0.152.
 */
package dev.lone.itemsadder.api;

import dev.lone.itemsadder.api.CustomStack;
import itemsadder.m.a;
import itemsadder.m.aoj;
import itemsadder.m.gz;
import itemsadder.m.nk;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.ItemFrame;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.jetbrains.annotations.Nullable;

public class CustomFurniture
extends CustomStack {
    private static final Set EMPTY_SET = new HashSet();
    Entity entity;
    private gz behaviour;

    public static Set getNamespacedIdsInRegistry() {
        Set set = a.d().b("furniture");
        if (set == null) {
            return EMPTY_SET;
        }
        return set;
    }

    CustomFurniture(nk nk2, Entity entity) {
        super(nk2);
        this.entity = entity;
        this.initItemStack(entity);
    }

    CustomFurniture(nk nk2, ItemStack itemStack, Entity entity, gz gz2) {
        super(nk2, itemStack);
        this.entity = entity;
        this.behaviour = gz2;
        this.initItemStack(entity);
    }

    private void initItemStack(Entity entity) {
        this.itemStack = gz.n(entity);
    }

    @Nullable
    public static CustomFurniture byAlreadySpawned(Entity entity) {
        ItemStack itemStack = gz.n(entity);
        if (!nk.isCustomItem(itemStack)) {
            return null;
        }
        nk nk2 = a.d().a(itemStack);
        if (nk2 == null) {
            return null;
        }
        gz gz2 = (gz)nk2.xo.aS("furniture");
        if (gz2 == null) {
            return null;
        }
        return new CustomFurniture(nk2, entity);
    }

    @Nullable
    public static CustomFurniture byAlreadySpawned(Block block) {
        Optional<Entity> optional = block.getLocation().getWorld().getNearbyEntities(block.getLocation().add(0.5, 0.5, 0.5), 0.1, 0.1, 0.1).stream().filter(gz::u).findFirst();
        return optional.map(CustomFurniture::byAlreadySpawned).orElse(null);
    }

    @Nullable
    public static CustomFurniture spawnPreciseNonSolid(String string, Location location) {
        nk nk2 = a.d().c(string);
        if (nk2 == null) {
            return null;
        }
        if (!nk2.xo.aR("furniture")) {
            return null;
        }
        ItemStack itemStack = nk2.jM();
        gz gz2 = (gz)nk2.xo.aS("furniture");
        Entity entity = gz2.a(itemStack, location);
        return new CustomFurniture(nk2, itemStack, entity, gz2);
    }

    @Nullable
    public static CustomFurniture spawn(String string, Block block) {
        nk nk2 = a.d().c(string);
        if (nk2 == null) {
            return null;
        }
        if (!nk2.xo.aR("furniture")) {
            return null;
        }
        ItemStack itemStack = nk2.jM();
        gz gz2 = (gz)nk2.xo.aS("furniture");
        Entity entity = gz2.a(itemStack, block);
        return new CustomFurniture(nk2, itemStack, entity, gz2);
    }

    public void remove(boolean bl2) {
        if (this.entity != null) {
            CustomFurniture.remove(this.entity, bl2);
        }
    }

    public static void remove(Entity entity, boolean bl2) {
        a.d().as.a(entity, bl2);
    }

    public void teleport(Entity entity) {
        this.teleport(entity.getLocation());
    }

    public void teleport(Location location) {
        if (this.entity != null) {
            if (this.behaviour.hP()) {
                this.behaviour.q(this.entity);
            }
            this.entity.teleport(location);
        }
    }

    public void replaceFurniture(String string) {
        this.replaceFurniture(string, null);
    }

    public void replaceFurniture(String string, Color color) {
        nk nk2 = a.d().c(string);
        if (nk2 == null) {
            throw new NoSuchElementException("No custom item with that namespacedId: " + string);
        }
        if (!nk2.xo.aR("furniture")) {
            throw new NoSuchElementException("Custom item has no furniture behaviour with that namespacedId: " + string);
        }
        if (gz.a(nk2, this.internalItem, this.entity)) {
            this.replace(this.itemStack, nk2);
            this.itemStack = nk2.jM();
            this.itemStack = gz.h(this.itemStack);
            if (color != null) {
                this.setColor(color);
            } else if (this.entity instanceof ArmorStand) {
                ((ArmorStand)this.entity).setHelmet(this.itemStack);
            } else if (this.entity instanceof ItemFrame) {
                ((ItemFrame)this.entity).setItem(this.itemStack, false);
            } else if (this.entity instanceof ItemDisplay) {
                ((ItemDisplay)this.entity).setItemStack(this.itemStack);
            }
        }
    }

    public void setColor(Color color) {
        ItemMeta itemMeta = this.itemStack.getItemMeta();
        if (itemMeta instanceof PotionMeta) {
            ((PotionMeta)itemMeta).setColor(color);
            this.itemStack.setItemMeta(itemMeta);
        } else if (itemMeta instanceof LeatherArmorMeta) {
            ((LeatherArmorMeta)itemMeta).setColor(color);
            this.itemStack.setItemMeta(itemMeta);
        }
        if (this.entity instanceof ArmorStand) {
            ((ArmorStand)this.entity).setHelmet(this.itemStack);
        } else if (this.entity instanceof ItemFrame) {
            ((ItemFrame)this.entity).setItem(this.itemStack, false);
        } else if (this.entity instanceof ItemDisplay) {
            ((ItemDisplay)this.entity).setItemStack(this.itemStack);
        }
    }

    public int getOriginalLightLevel() {
        return this.behaviour.hO();
    }

    public void setCurrentLightLevel(int n2) {
        aoj.aZ(this.entity.getLocation().getBlock());
        aoj.d(this.entity.getLocation().getBlock(), n2);
    }

    @Deprecated
    @Nullable
    public Entity getArmorstand() {
        return this.entity;
    }

    @Nullable
    public Entity getEntity() {
        return this.entity;
    }
}

