/*
 * Decompiled with CFR 0.152.
 */
package dev.lone.itemsadder.api.scriptinginternal;

import dev.lone.itemsadder.Main;
import dev.lone.itemsadder.api.CustomBlock;
import dev.lone.itemsadder.api.scriptinginternal.ScriptingUtils;
import ia.sh.com.jeff_media.customblockdata.CustomBlockData;
import itemsadder.m.a;
import itemsadder.m.aoj;
import itemsadder.m.aoq;
import itemsadder.m.im;
import itemsadder.m.in;
import itemsadder.m.jy;
import itemsadder.m.nj;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class WorldUtils {
    public static boolean isCustom(Block block) {
        if (block == null) {
            return false;
        }
        if (block.getType() == Material.AIR) {
            return false;
        }
        return a.isCustomBlock(block);
    }

    @Nullable
    public static CustomBlock customBlock(Block block) {
        if (block == null) {
            return null;
        }
        if (block.getType() == Material.AIR) {
            return null;
        }
        return CustomBlock.byAlreadyPlaced(block);
    }

    @Nullable
    public static CustomBlock customBlock(Location location) {
        if (location == null) {
            return null;
        }
        Block block = location.getBlock();
        return WorldUtils.customBlock(block);
    }

    @Nullable
    public static Block block(String string, int n2, int n3, int n4) {
        if (string == null) {
            return null;
        }
        World world = Bukkit.getWorld((String)string);
        if (world == null) {
            return null;
        }
        return world.getBlockAt(n2, n3, n4);
    }

    public static Block block(World world, int n2, int n3, int n4) {
        return world.getBlockAt(n2, n3, n4);
    }

    @Nullable
    public static Block block(Location location) {
        if (location.getWorld() == null) {
            return null;
        }
        return location.getWorld().getBlockAt(location);
    }

    public static void removeBlock(Block block) {
        if (block == null) {
            return;
        }
        if (block.getType() == Material.AIR) {
            return;
        }
        Location location = block.getLocation();
        jy jy2 = a.d().a(location);
        if (!jy2.isCustomBlock(block)) {
            block.setType(Material.AIR);
            return;
        }
        jy2.Y(block);
        aoj.aZ(block);
    }

    public static void placeBlock(Block block, Material material) {
        if (block == null) {
            return;
        }
        if (block.getType() == material) {
            return;
        }
        Location location = block.getLocation();
        jy jy2 = a.d().a(location);
        if (jy2.isCustomBlock(block)) {
            jy2.Y(block);
            aoj.aZ(block);
        }
        block.setType(material);
    }

    public static boolean placeBlock(Block block, String string) {
        aoj.aZ(block);
        Material material = Material.matchMaterial((String)string);
        if (material != null) {
            WorldUtils.placeBlock(block, material);
            return true;
        }
        CustomBlock customBlock = CustomBlock.getInstance(string);
        if (customBlock != null) {
            customBlock.place(block.getLocation());
            return true;
        }
        return false;
    }

    public static void placeBlock(Block block, CustomBlock customBlock) {
        aoj.aZ(block);
        customBlock.place(block.getLocation());
    }

    public static Location location(String string, int n2, int n3, int n4) {
        if (string == null) {
            return null;
        }
        World world = Bukkit.getWorld((String)string);
        if (world == null) {
            return null;
        }
        return new Location(world, (double)n2, (double)n3, (double)n4);
    }

    public static void breakBlockNaturally(Player player, int n2, int n3, int n4) {
        Location location = new Location(player.getWorld(), (double)n2, (double)n3, (double)n4);
        Block block = location.getBlock();
        WorldUtils.breakBlockNaturally(player, block);
    }

    public static void breakBlockNaturally(Player player, Block block) {
        if (block == null || block.getType() == Material.AIR) {
            return;
        }
        Location location = block.getLocation();
        jy jy2 = a.d().a(location);
        if (!jy2.isCustomBlock(block)) {
            block.breakNaturally();
            return;
        }
        String string = jy2.Q(block);
        nj nj2 = a.d().f(string);
        if (nj2 == null) {
            throw new RuntimeException("Unknown custom block: " + string);
        }
        im im2 = new im(player, block, nj2, jy2);
        in.b(im2);
    }

    public static void breakBlockNaturally(Block block) {
        if (block == null || block.getType() == Material.AIR) {
            return;
        }
        Location location = block.getLocation();
        jy jy2 = a.d().a(location);
        if (!jy2.isCustomBlock(block)) {
            block.breakNaturally();
            return;
        }
        String string = jy2.Q(block);
        nj nj2 = a.d().f(string);
        if (nj2 == null) {
            throw new RuntimeException("Unknown custom block: " + string);
        }
        in.a(jy2, block, nj2);
    }

    public static void playParticle(Location location, String string) {
        WorldUtils.playParticle(location, string, 1, 0.0, 0.0, 0.0, 0.0);
    }

    public static void playParticle(Location location, String string, int n2) {
        WorldUtils.playParticle(location, string, n2, 0.0, 0.0, 0.0, 0.0);
    }

    public static void playParticle(World world, double d2, double d3, double d4, String string, int n2, double d5, double d6, double d7, double d8) {
        WorldUtils.playParticle(new Location(world, d2, d3, d4), string, n2, d5, d6, d7, d8);
    }

    public static void playParticle(Location location, String string, int n2, double d2, double d3, double d4, double d5) {
        if (location == null || string == null || string.isEmpty()) {
            throw new RuntimeException("Invalid parameters for playParticle");
        }
        Particle particle = aoq.fy(string);
        if (particle == null) {
            throw new RuntimeException("Invalid particle name: " + string);
        }
        location.getWorld().spawnParticle(particle, location, n2, d2, d3, d4, d5);
    }

    public static void playSound(Location location, String string) {
        if (location == null || string == null || string.isEmpty()) {
            throw new RuntimeException("Invalid parameters for playSound");
        }
        location.getWorld().playSound(location, string, 1.0f, 1.0f);
    }

    public static void playSound(Location location, String string, float f2, float f3) {
        if (location == null || string == null || string.isEmpty()) {
            throw new RuntimeException("Invalid parameters for playSound");
        }
        location.getWorld().playSound(location, string, f2, f3);
    }

    private static PersistentDataContainer getContainer(Block block) {
        if (block == null) {
            throw new IllegalArgumentException("Block cannot be null");
        }
        a.d().x.nA();
        return new CustomBlockData(block, (Plugin)Main.nW());
    }

    public static boolean hasData(Block block, String string, String string2) {
        PersistentDataContainer persistentDataContainer = WorldUtils.getContainer(block);
        return ScriptingUtils.hasData(persistentDataContainer, string, string2);
    }

    public static void removeData(Block block, String string, String string2) {
        PersistentDataContainer persistentDataContainer = WorldUtils.getContainer(block);
        ScriptingUtils.removeData(persistentDataContainer, string, string2);
    }

    public static void setDataByte(Block block, String string, String string2, byte by2) {
        PersistentDataContainer persistentDataContainer = WorldUtils.getContainer(block);
        ScriptingUtils.setDataByte(persistentDataContainer, string, string2, by2);
    }

    public static void setDataShort(Block block, String string, String string2, short s2) {
        PersistentDataContainer persistentDataContainer = WorldUtils.getContainer(block);
        ScriptingUtils.setDataShort(persistentDataContainer, string, string2, s2);
    }

    public static void setDataInt(Block block, String string, String string2, int n2) {
        PersistentDataContainer persistentDataContainer = WorldUtils.getContainer(block);
        ScriptingUtils.setDataInt(persistentDataContainer, string, string2, n2);
    }

    public static void setDataLong(Block block, String string, String string2, long l2) {
        PersistentDataContainer persistentDataContainer = WorldUtils.getContainer(block);
        ScriptingUtils.setDataLong(persistentDataContainer, string, string2, l2);
    }

    public static void setDataFloat(Block block, String string, String string2, float f2) {
        PersistentDataContainer persistentDataContainer = WorldUtils.getContainer(block);
        ScriptingUtils.setDataFloat(persistentDataContainer, string, string2, f2);
    }

    public static void setDataDouble(Block block, String string, String string2, double d2) {
        PersistentDataContainer persistentDataContainer = WorldUtils.getContainer(block);
        ScriptingUtils.setDataDouble(persistentDataContainer, string, string2, d2);
    }

    public static void setDataBool(Block block, String string, String string2, boolean bl2) {
        PersistentDataContainer persistentDataContainer = WorldUtils.getContainer(block);
        ScriptingUtils.setDataBool(persistentDataContainer, string, string2, bl2);
    }

    public static void setDataString(Block block, String string, String string2, String string3) {
        PersistentDataContainer persistentDataContainer = WorldUtils.getContainer(block);
        ScriptingUtils.setDataString(persistentDataContainer, string, string2, string3);
    }

    public static byte getDataByte(Block block, String string, String string2, byte by2) {
        PersistentDataContainer persistentDataContainer = WorldUtils.getContainer(block);
        return ScriptingUtils.getDataByte(persistentDataContainer, string, string2, by2);
    }

    public static short getDataShort(Block block, String string, String string2, short s2) {
        PersistentDataContainer persistentDataContainer = WorldUtils.getContainer(block);
        return ScriptingUtils.getDataShort(persistentDataContainer, string, string2, s2);
    }

    public static int getDataInt(Block block, String string, String string2, int n2) {
        PersistentDataContainer persistentDataContainer = WorldUtils.getContainer(block);
        return ScriptingUtils.getDataInt(persistentDataContainer, string, string2, n2);
    }

    public static long getDataLong(Block block, String string, String string2, long l2) {
        PersistentDataContainer persistentDataContainer = WorldUtils.getContainer(block);
        return ScriptingUtils.getDataLong(persistentDataContainer, string, string2, l2);
    }

    public static float getDataFloat(Block block, String string, String string2, float f2) {
        PersistentDataContainer persistentDataContainer = WorldUtils.getContainer(block);
        return ScriptingUtils.getDataFloat(persistentDataContainer, string, string2, f2);
    }

    public static double getDataDouble(Block block, String string, String string2, double d2) {
        PersistentDataContainer persistentDataContainer = WorldUtils.getContainer(block);
        return ScriptingUtils.getDataDouble(persistentDataContainer, string, string2, d2);
    }

    public static boolean getDataBool(Block block, String string, String string2, boolean bl2) {
        PersistentDataContainer persistentDataContainer = WorldUtils.getContainer(block);
        return ScriptingUtils.getDataBool(persistentDataContainer, string, string2, bl2);
    }

    public static String getDataString(Block block, String string, String string2, String string3) {
        PersistentDataContainer persistentDataContainer = WorldUtils.getContainer(block);
        return ScriptingUtils.getDataString(persistentDataContainer, string, string2, string3);
    }
}

